/*******************************************************************
*
*  DESCRIPTION: Atomic Model Chief
*
*
*******************************************************************/

/** include files **/
#include "chief1.h"      // class Subnet
#include "message.h"    // class ExternalMessage, InternalMessage
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "strutil.h"       // str2float( ... )
#include <stdlib.h>

/** public functions **/

/*******************************************************************
* Function Name: Chief1
* Description:
********************************************************************/
chief1::chief1( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, out( addOutputPort( "out" ) )
, orderout( addOutputPort( "orderout" ) )
, preparationTime( 0, 0, 1, 0 )
{
	//index = 1;
	order = 1;
	try
	{
		dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );

		MASSERT( dist );

		for ( register int i = 0 ; i < dist->varCount() ; i++ )
		{
			string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar(i) ) ) ;
			dist->setVar( i, str2float( parameter ) ) ;
		}
	} catch( InvalidDistribution &e )
	{
		e.addText( "The model " + description() + " has distribution problems!" ) ;
		e.print(cerr);
		MTHROW( e ) ;
	} catch( MException &e )
	{
		MTHROW( e ) ;
	}
}

/*******************************************************************
* Function Name: initFunction
* Description: Resetea la lista
* Precondition: El tiempo del proximo evento interno es Infinito
********************************************************************/
Model &chief1::initFunction()
{

	this-> passivate();
	//packet = 0;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &chief1::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == in )
	{	//index ++;
		order_bit = static_cast < int > (msg.value());

		if (order_bit == 1){
		//Time t(fabs(this->distribution().get()));
			std::cout<<" chief1 : orderbit = " << order_bit <<std::endl;
			holdIn( active, preparationTime );
			//holdIn( active, Time( static_cast<float>( fabs( distribution().get() ) ) ) );
		}
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &chief1::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &chief1::outputFunction( const InternalMessage &msg )
{	//if ((double)rand() / (double) RAND_MAX  < 0.95)
	sendOutput( msg.time(), out ,order ) ;//correct place
	sendOutput( msg.time(), orderout ,order ) ;//correct place

	//sendOutput( msg.time()) ;//correct place
	return *this ;
}

chief1::~chief1()
{
	delete dist;
}
